'************************************************
' File:    WinVersion.vbs (WSH sample in VBScript) 
' Author:  Gnter Born
'
' Retrieve OS-Version number
' Attention: Requires WSHSystem.ocx
' Check out Born's Windows Scripting Host Bazaar at:
' http://ourworld.compuserve.com/homepages/Guenter_Born/index0.htm
'
' In no way shall the author be liable for any
' losses or damages resulting from the use of this
' program. Use AS-IS at your own risk.
'
' The code is the property of the author. You may
' use the code and modify it, as far as this header
' remains intact. Further updates and other samples
' may be found on my site mentioned above.

'************************************************
Option Explicit

Const xMajorVer = 1
Const xMinorVer = 2
Const xBuild = 3
Const xPlatform = 4
Const xTxt = 5

Const VER_PLATFORM_WIN32s = 0
Const VER_PLATFORM_WIN32_WINDOWS = 1
Const VER_PLATFORM_WIN32_NT = 2

Dim objAdr, Text, Title, OSName

 Title = "Operating System Information - by Gnter Born"
 Text = "Windows Properties" & vbCRLF

' Get a reference to the WSHExtend control
 Set objAdr = WScript.CreateObject("WSHSystem.WinSys")

 objAdr.WSHOsSysInfo               ' Get Windows-OS-Info

 Text = Text + "Platform "
' Estimate OS-Platform
 Select Case objAdr.OsSysInfoValue(xPlatform)
 Case VER_PLATFORM_WIN32_WINDOWS
  If objAdr.OsSysInfoValue(xMajorVer) = 4 _
   And objAdr.OsSysInfoValue(xMinorVer) = 0 Then
    Text = Text & "Windows 95"
  Else
    Text = Text & "Windows 98"
  End If

 Case VER_PLATFORM_WIN32_NT
  If objAdr.OsSysInfoValue(xMajorVer) = 5 _
   And objAdr.OsSysInfoValue(xMinorVer) = 0 Then
    Text = Text & "Windows 2000"
  Else
    Text = Text & "Windows NT 4.x"
  End If
 Case Else
  Text = Text & "---"
 End Select

 Text = Text & vbCRLF

' Extract other Operating System Properties
 Text = Text & "Version " & objAdr.OsSysInfoValue(xMajorVer)
 Text = Text & "." & objAdr.OsSysInfoValue(xMinorVer) & vbCRLF
 Text = Text & "Build " & (objAdr.OsSysInfoValue(xBuild) AND &HFFF) 
 Text = Text & " " & objAdr.OsSysInfoValue(xTxt) & vbCRLF

 MsgBox Text, vbOkOnly + vbInformation, Title

 WScript.Quit()
' End